<?php

namespace App\Exports\Mdr;

use Maatwebsite\Excel\Concerns\Exportable;
use Maatwebsite\Excel\Concerns\WithMultipleSheets;

class MdrExport implements WithMultipleSheets
{
    use Exportable;

    public function __construct(public int $projectId, public array $filters = [])
    {
    }

    public function sheets(): array
    {
        // استفاده از شیتهای بهبود یافته
        return [
            new Sheets\SummarySheet($this->projectId, $this->filters),
            new Sheets\MasterDocumentsSheet($this->projectId, $this->filters),
            new Sheets\RevisionsSheet($this->projectId, $this->filters),
        ];
    }
}
