<?php


namespace App\Http\Controllers;

use App\Models\Announcement;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Illuminate\Support\Facades\Storage;
use ZipArchive;

class AnnouncementAttachmentZipController extends Controller
{
    public function __invoke(Request $request, Announcement $announcement)
    {
        $userId = Auth::id();

        // فقط گیرنده یا فرستنده حق دانلود دارد
        $isRecipient = $announcement->recipients()->where('users.id', $userId)->exists();
        if (!$isRecipient && $announcement->sender_id !== $userId) {
            abort(403, 'دسترسی ندارید.');
        }

        // جمع فایل‌ها: attachments (چندتایی) + fallback ستون file قدیمی
        $files = [];
        $attachments = $announcement->attachments()->get();
        foreach ($attachments as $att) {
            if ($att->path && Storage::disk('public')->exists($att->path)) {
                $files[] = [
                    'full' => Storage::disk('public')->path($att->path),
                    'name' => $att->original_name ?: basename($att->path),
                ];
            }
        }
        if (empty($files) && $announcement->file && Storage::disk('public')->exists($announcement->file)) {
            $files[] = [
                'full' => Storage::disk('public')->path($announcement->file),
                'name' => basename($announcement->file),
            ];
        }
        if (empty($files)) {
            abort(404, 'فایلی برای دانلود وجود ندارد.');
        }

        $zipName = 'announcement-'.$announcement->id.'-attachments.zip';
        $tmpDir  = storage_path('app/temp');
        if (!is_dir($tmpDir)) @mkdir($tmpDir, 0775, true);
        $zipPath = $tmpDir . DIRECTORY_SEPARATOR . $zipName;

        $zip = new ZipArchive();
        if ($zip->open($zipPath, ZipArchive::CREATE | ZipArchive::OVERWRITE) !== true) {
            abort(500, 'امکان ساخت فایل ZIP نیست.');
        }
        foreach ($files as $f) {
            $zip->addFile($f['full'], $f['name']);
        }
        $zip->close();

        return response()->download($zipPath, $zipName)->deleteFileAfterSend(true);
    }
}
