<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Storage;
use Illuminate\Support\Facades\Response;

class AttachmentController extends Controller
{
    /**
     * مدیریت آپلود تصاویر از ویرایشگر TinyMCE.
     * این متد باید در routes/web.php به نام 'upload.tinymce.image' متصل شود.
     *
     * @param Request $request
     * @return \Illuminate\Http\JsonResponse
     */
    public function uploadTinymceImage(Request $request)
    {
        // 1. اعتبارسنجی
        $request->validate([
            'image' => 'required|image|max:5120', // حداکثر 5 مگابایت
        ], [
            'image.max' => 'حجم فایل تصویر نباید بیشتر از ۵ مگابایت باشد.',
            'image.image' => 'فایل ارسالی باید تصویر معتبر باشد.',
        ]);

        try {
            // 2. ذخیره فایل در مسیر عمومی
            // فایل‌ها در storage/app/public/tinymce_uploads ذخیره می‌شوند
            $path = $request->file('image')->store('tinymce_uploads', 'public');

            // 3. بازگرداندن پاسخ JSON مورد نیاز TinyMCE
            // 'location' باید URL قابل دسترسی عمومی باشد
            return response()->json([
                'location' => Storage::url($path)
            ]);

        } catch (\Exception $e) {
            // 4. هندل کردن خطا
            \Log::error("TinyMCE Upload Error: " . $e->getMessage());

            return response()->json([
                'error' => [
                    'message' => 'خطا در ذخیره‌سازی تصویر. لطفاً مجدداً تلاش کنید.'
                ]
            ], 500);
        }
    }
}
