<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;

class GalleryController extends Controller
{

    public function ckeditor_image(Request $request)
    {
        $validator = Validator::make($request->all(), [
            'upload' => 'required|image|mimes:jpeg,png,jpg,gif,svg|max:2048', // Validate file type and size
        ]);

        if ($validator->fails()) {
            return response()->json(['error' => $validator->errors()->first('upload')], 400); // Return error message
        }

        if ($request->hasFile('upload')) {
            $file = $request->file('upload');
            $name = time() . '.' . $file->getClientOriginalExtension();
            $file->storeAs('images/letters', $name, 'public');
            $url = asset('storage/images/letters/' . $name); // Correct URL generation
            return response()->json(['url' => $url]);
        }

        return response()->json(['error' => 'File upload failed.'], 500); // Handle upload failure
    }

//    public function ckeditor_image(Request $request)
//    {
//        if ($request->hasFile('upload'))
//        {
//            $name = time() . '.' . $request->upload->getClientOriginalExtension();
//            $request->upload->storeAs('images/letters', $name, 'public');
//            $url = url('app/images/letters/' . $name);
//            return response()->json(['url' => $url]);
//        }
//    }

}
