<?php

namespace App\Http\Controllers;

use App\Models\Transmittal;
use Illuminate\Http\Request;
use ZipArchive;
use Storage;

class TransmittalController extends Controller
{
    public function downloadAttachmentsZip($id)
    {
        // پیدا کردن ترنسمیتال با شناسه
        $transmittal = Transmittal::with('attachments')->findOrFail($id);

        // ایجاد نام فایل ZIP
        $zipFileName = 'transmittal_' . $transmittal->transmittal_number . '_attachments.zip';

        // مسیر ذخیره فایل موقت
        $zipFilePath = storage_path('app/public/' . $zipFileName);

        // ایجاد فایل ZIP
        $zip = new ZipArchive();
        if ($zip->open($zipFilePath, ZipArchive::CREATE) !== true) {
            return response()->json(['error' => 'Unable to create ZIP file.'], 500);
        }

        // افزودن فایل‌های پیوست به ZIP
        foreach ($transmittal->attachments as $attachment) {
            $filePath = storage_path('app/public/' . $attachment->file_path);
            if (file_exists($filePath)) {
                $zip->addFile($filePath, $attachment->file_name);
            }
        }

        // بستن فایل ZIP
        $zip->close();

        // ارسال فایل ZIP به کاربر برای دانلود
        return response()->download($zipFilePath)->deleteFileAfterSend(true);
    }
}
