<?php
// App/Http/Middleware/CheckUserStatus.php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class CheckUserStatus
{
    public function handle(Request $request, Closure $next): Response
    {
        // ۱. نادیده گرفتن مسیرهای ضروری (مانند لاگین، لاگ اوت، و مسیر ارسال نوتیفیکیشن)
        if ($request->routeIs('login', 'logout', 'account.inactive', 'account.notify-admin')) {
            return $next($request);
        }

        if (Auth::check() && !Auth::user()->is_active) {
            // کاربر غیرفعال است. لاگ اوت نکنید تا بتواند درخواست بفرستد.
            // به صفحه اطلاع‌رسانی هدایت کنید.
            return redirect()->route('account.inactive')
                ->with('status', 'حساب کاربری شما فعال نیست و دسترسی شما محدود شده است.');
        }

        return $next($request);
    }
}
