<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;

class ProjectMemberMiddleware
{
    public function handle(Request $request, Closure $next): Response
    {
        // گرفتن project_id از route parameters (پشتیبانی از `projectId` و `project`)
        $projectId = $request->route('projectId') ?? $request->route('project');

        if (!$projectId) {
            abort(403, 'پروژه مشخص نشده است.');
        }

        // یافتن پروژه
        $project = \App\Models\Project::findOrFail($projectId);

        // کاربر جاری
        $user = $request->user();

        if (!$user) {
            abort(403);
        }

        // اگر ادمین است → عبور
        if ($user->isAdmin()) {
            return $next($request);
        }

        // اگر عضو پروژه (از طریق جدول user_roles) است → عبور
        if ($user->projects()->where('project_id', $project->id)->exists()) {
            return $next($request);
        }

        // 💡 **اختیاری**: اگر می‌خواهید **کارمندان شرکت‌های ذینفع** (مثل کارفرما/پیمانکار) هم دسترسی داشته باشند:
        // (الان فعال است — اگر نمی‌خواهید، خط پایین را کامنت کنید)
        if ($user->company && $project->parties()->where('company_id', $user->company->id)->exists()) {
            return $next($request);
        }

        // در غیر این‌صورت → ممنوع
        abort(403, 'شما به این پروژه دسترسی ندارید.');
    }
}
