<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Auth;
use Symfony\Component\HttpFoundation\Response;

class ProjectMembershipGate
{
    /**
     * Handle an incoming request.
     */
    public function handle(Request $request, Closure $next): Response
    {
        // 1. اطمینان از لاگین بودن کاربر
        if (Auth::check()) {
            $user = Auth::user();

            // 2. چک کردن نقش مدیر (Admin Bypass)
            // اگر کاربر Admin است (بر اساس نقش استرینگ یا roleObject)، همیشه اجازه دسترسی دارد.
            if ($user->role === 'admin' || $user->roleObject?->name === 'admin') {
                return $next($request);
            }

            // 3. چک کردن عضویت در پروژه (برای کاربران عادی)
            // 💡 اگر کاربر عضو حداقل یک پروژه باشد (از طریق رابطه members در مدل User)
            // ما از رابطه 'projects' که در مدل User تعریف کردید، استفاده می‌کنیم.
            if ($user->projects()->exists()) {
                return $next($request);
            }

            // 🛑 اگر عضو هیچ پروژه‌ای نیست
            Auth::logout();
            $request->session()->invalidate();
            $request->session()->regenerateToken();

            return redirect()->route('login')->withErrors([
                'email' => 'شما اجازه دسترسی ندارید. حساب کاربری شما به هیچ پروژه‌ای اختصاص داده نشده است.'
            ]);
        }

        // اگر لاگین نکرده، اجازه دهید به مسیرهای عمومی برود (مثل لاگین)
        return $next($request);
    }
}
