<?php
namespace App\Jobs;

use App\Models\ProjectInsurance;
use App\Models\ProjectSchedule;
use App\Notifications\DeadlineReminder;
use Illuminate\Bus\Queueable;
use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Bus\Dispatchable;
use Illuminate\Queue\InteractsWithQueue;
use Illuminate\Queue\SerializesModels;

class CheckDeadlines implements ShouldQueue
{
    use Dispatchable, InteractsWithQueue, Queueable, SerializesModels;

    public function handle()
    {
        // بررسی بیمه‌ها (7 روز آینده)
        $insurances = ProjectInsurance::where('end_date', '<=', now()->addDays(7))
            ->where('end_date', '>=', now())
            ->with('project')
            ->get();

        foreach ($insurances as $insurance) {
            $insurance->project->users()->each(function ($user) use ($insurance) {
                $user->notify(new DeadlineReminder(
                    'بیمه',
                    $insurance->end_date,
                    $insurance->project->name,
                    $insurance->project->id
                ));
            });
        }

        // بررسی زمان‌بندی پروژه (7 روز آینده)
        $schedules = ProjectSchedule::where('actual_completion_date', '<=', now()->addDays(7))
            ->where('actual_completion_date', '>=', now())
            ->with('project')
            ->get();

        foreach ($schedules as $schedule) {
            $schedule->project->users()->each(function ($user) use ($schedule) {
                $user->notify(new DeadlineReminder(
                    'پایان پروژه',
                    $schedule->actual_completion_date,
                    $schedule->project->name,
                    $schedule->project->id
                ));
            });
        }
    }
}
