<?php

namespace App\Livewire\Admin\Announcement;

use App\Models\Announcement;
use Illuminate\Support\Facades\Auth;
use Livewire\Component;

class AttachmentZipButton extends Component
{
    public int $announcementId;
    public bool $busy = false;
    public bool $hasAttachments = false;

    public function mount(int $announcementId): void
    {
        $this->announcementId = $announcementId;

        $a = Announcement::query()
            ->select('id','sender_id','file')
            ->withCount('attachments')
            ->findOrFail($announcementId);

        $this->hasAttachments = ($a->attachments_count > 0) || !empty($a->file);
    }

    public function download(): void
    {
        if (!$this->hasAttachments) {
            $this->dispatch('toast', type: 'warning', message: 'فایلی برای دانلود وجود ندارد.');
            return;
        }

        $a   = Announcement::findOrFail($this->announcementId);
        $uid = Auth::id();

        $isRecipient = $a->recipients()->where('users.id',$uid)->exists();
        if (!$isRecipient && $a->sender_id !== $uid) {
            $this->dispatch('toast', type: 'error', message: 'دسترسی ندارید.');
            return;
        }

        $this->busy = true;
        $url = route('announcements.attachments.zip', $a);
        $this->dispatch('download:zip', url: $url);
        $this->busy = false;
    }

    public function render()
    {
        // هیچ متغیر blade اضافه پاس نده؛ از $this در Blade استفاده می‌کنیم
        return view('livewire.admin.announcement.attachment-zip-button');
    }
}
