<?php

namespace App\Livewire\Admin\Chat;

use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithFileUploads;
use App\Models\Chat;
use App\Models\Message;
use Auth;


class ChatManagement extends Component
{
    use WithFileUploads;

    public $chats;
    public $chat_id;
    public $message;
    public $file;

    public function mount()
    {
        $this->chats = Chat::with('messages.user')->get();
    }

    protected $rules = [
        'chat_id' => 'required|exists:chats,id',
        'message' => 'required_without:file|string',
        'file' => 'nullable|file|max:10240', // حداکثر 10 مگابایت
    ];

    public function sendMessage()
    {
        $this->validate();

        $filePath = null;
        if ($this->file) {
            $filePath = $this->file->store('chat_files');
        }

        Message::create([
            'chat_id' => $this->chat_id,
            'user_id' => Auth::id(),
            'message' => $this->message,
            'file_path' => $filePath,
        ]);

        session()->flash('message', 'پیام با موفقیت ارسال شد.');
        $this->resetFields();
        $this->chats = Chat::with('messages.user')->get();
    }

    public function resetFields()
    {
        $this->message = '';
        $this->file = null;
    }


    #[layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.chat.chat-management', [
            'chats' => $this->chats,
        ]);
    }
}
