<?php

namespace App\Livewire\Admin\Chat;


use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithFileUploads;
use App\Models\User;
use App\Models\Message;
use App\Models\Chat;
use Auth;

class ChatWithUser extends Component
{

    use WithFileUploads;

    public $userId;
    public $chat;
    public $message;
    public $file;
    public $messages;

    public function mount($userId)
    {
        $this->userId = $userId;
        $this->chat = Chat::firstOrCreate(
            ['name' => 'Chat between ' . Auth::id() . ' and ' . $userId],
            ['name' => 'Chat between ' . Auth::id() . ' and ' . $userId]
        );
        $this->messages = $this->chat->messages()->with('user')->get()->toArray();
    }

    protected $rules = [
        'message' => 'required_without:file|string',
        'file' => 'nullable|file|max:10240', // حداکثر 10 مگابایت
    ];

    public function sendMessage()
    {
        $this->validate();

        $filePath = null;
        if ($this->file) {
            $filePath = $this->file->store('chat_files');
        }

        Message::create([
            'chat_id' => $this->chat->id,
            'user_id' => Auth::id(),
            'message' => $this->message,
            'file_path' => $filePath,
        ]);

        $this->resetFields();
        $this->messages = $this->chat->messages()->with('user')->get()->toArray();
    }

    public function resetFields()
    {
        $this->message = '';
        $this->file = null;
    }
    #[layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.chat.chat-with-user' ,[
        'chat' => $this->chat,
            'messages' => $this->messages,
        ]);
    }
}
