<?php

namespace App\Livewire\Admin\Company;

use App\Models\Company;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\Storage;

class CreateCompany extends Component
{
    use WithFileUploads;

    public $name;
    public $fax;
    public $tel;
    public $image;
    public $address; // ✨ فیلد جدید آدرس

    // قوانین اعتبارسنجی
    protected $rules = [
        'name' => 'required|min:3|max:255',
        'tel' => 'nullable|min:6|max:20',
        'fax' => 'nullable|min:6|max:20',
        'image' => 'nullable|image|mimes:jpeg,png,jpg,gif,svg,webp|max:2048',
        'address' => 'nullable|string|max:500', // ✨ قانون جدید برای آدرس
    ];

    #[Layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.company.create-company');
    }

    // ✨ تغییر نام متد به saveCompany برای خوانایی بهتر
    public function saveCompany()
    {
        $this->validate();

        $img = null;
        if ($this->image) {
            // ذخیره لوگو در دیسک 'company' (فرض بر وجود پیکربندی دیسک)
            $img = time() . '_' . $this->image->getClientOriginalName();
            // ⚠️ توجه: اگر دیسک 'company' در filesystems.php ریشه public_path() ندارد، باید از storeAs استفاده کنید.
            // بر اساس پیکربندی شما، دیسک 'company' به public_path('app/images/users/') اشاره دارد.
            $this->image->storeAs('images/company/', $img, 'public'); // استفاده از دیسک public برای ذخیره در پوشه عمومی
        }

        // ایجاد رکورد جدید برای شرکت
        Company::create([
            'name' => $this->name,
            'fax' => $this->fax,
            'tel' => $this->tel,
            'image' => $img,
            'address' => $this->address, // ✨ ذخیره فیلد آدرس
        ]);

        // ریست کردن فرم
        $this->reset(['name', 'fax', 'tel', 'image', 'address']);

        // ارسال پیام موفقیت
        session()->flash('message', 'شرکت با موفقیت ایجاد گردید');

        // ارسال رویداد
        $this->dispatch('CompanyCreated');
    }
}
