<?php

namespace App\Livewire\Admin\Contract;

use App\Models\ContractStatus;
use Livewire\Attributes\Layout;
use Livewire\Component;

class ContractStatusCreate extends Component
{

    public $name;

    protected $rules = [

        'name' => 'required|min:2',
    ];

    #[layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.contract.contract-status-create');
    }

    public function SaveContractStatus()
    {
        $this->validate();

        ContractStatus::query()->create([
            'name' => $this->name,
        ]);
        $this->reset('name');
        session()->flash('message', 'مجوز  با موفقیت ایجاد گردید');
        $this->dispatch('Permissions-Created');
    }
}
