<?php

namespace App\Livewire\Admin\Item;

use App\Models\Item;
use Livewire\Attributes\Layout;
use Livewire\Component;

class ItemList extends Component
{
    public $sortId = true;
    public $search = "";

    #[Layout('admin.master')]
    public function render()
    {
        $items = Item::query()
            ->orderBy('id', $this->sortId ? 'asc' : 'desc')
            ->where('name', 'LIKE', '%'.$this->search.'%')
            ->paginate(20);

        return view('livewire.admin.item.item-list', compact('items'));
    }
}
