<?php

namespace App\Livewire\Admin\Item;

use App\Models\Item;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;

class ItemManagement extends Component
{
    use WithPagination;

    public $name;
    public $code;
    public $editId = null;
    public $search = '';
    protected $paginationTheme = 'bootstrap';

    protected $rules = [
        'name' => 'required|string|max:255',
        'code' => 'required|string|max:50|unique:items,code',
    ];

    public function saveItem()
    {
        $this->validate();

        if ($this->editId) {
            $item = Item::findOrFail($this->editId);
            $item->update([
                'name' => $this->name,
                'code' => $this->code,
            ]);
            session()->flash('message', 'کالا با موفقیت ویرایش شد.');
        } else {
            Item::create([
                'name' => $this->name,
                'code' => $this->code,
            ]);
            session()->flash('message', 'کالا با موفقیت ثبت شد.');
        }

        $this->resetFields();
    }

    public function editItem($id)
    {
        $item = Item::findOrFail($id);
        $this->editId = $id;
        $this->name = $item->name;
        $this->code = $item->code;
    }

    public function deleteItem($id)
    {
        Item::findOrFail($id)->delete();
        session()->flash('message', 'کالا با موفقیت حذف شد.');
    }

    public function resetFields()
    {
        $this->editId = null;
        $this->name = '';
        $this->code = '';
        $this->dispatch('closeModal');
    }

    #[Layout('admin.master')]
    public function render()
    {
        $items = Item::query()
            ->when($this->search, function ($query) {
                $query->where('name', 'like', '%' . $this->search . '%')
                    ->orWhere('code', 'like', '%' . $this->search . '%');
            })
            ->paginate(10);

        return view('livewire.admin.item.item-management', [
            'items' => $items,
        ]);
    }
}
