<?php

namespace App\Livewire\Admin\Letter;

use App\Models\Letter;
use App\Models\Project;
use Livewire\Attributes\Layout;
use Livewire\Component;

class ArchiveLetter extends Component
{

    public $letter_id, $project_id;
    public $letters, $projects;

    public function mount()
    {
        $this->letters = Letter::all();
        $this->projects = Project::all();
    }

    protected $rules = [
        'letter_id' => 'required|exists:letters,id',
        'project_id' => 'required|exists:projects,id',
    ];

    public function saveArchive()
    {
        $this->validate();

        $letter = Letter::find($this->letter_id);
        $letter->project_id = $this->project_id;
        $letter->save();

        session()->flash('message', 'نامه با موفقیت بایگانی شد.');
        $this->resetFields();
    }

    public function resetFields()
    {
        $this->letter_id = null;
        $this->project_id = null;
    }

    #[layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.letter.archive-letter');
    }
}
