<?php

namespace App\Livewire\Admin\Letter\Classification;

use App\Models\Classification;
use Livewire\Attributes\Layout;
use Livewire\Component;

class AddClassification extends Component
{
    public $name;

    protected $rules = [
        'name' => 'required|min:2|unique:classifications,name', // اضافه کردن unique
    ];

    #[layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.letter.classification.add-classification');
    }

    public function SaveType()
    {
        $this->validate();

        Classification::query()->create([
            'name' => $this->name,
        ]);

        $this->reset('name');

        // --- جایگزینی session()->flash با Livewire Event برای نمایش Toast مدرن ---
        $this->dispatch('toast-message', message: 'نوع نامه با موفقیت ایجاد گردید.', type: 'success');

        $this->dispatch('Classification-Created');
    }
}
