<?php

namespace App\Livewire\Admin\Letter\Create;

use App\Models\Letter;
use App\Models\LetterTemplate;
use App\Models\User;
use Livewire\Component;
use Livewire\WithFileUploads;

class CreateLetterForm extends Component
{ use WithFileUploads;

    public $templateId;
    public $template;
    public $title;
    public $sender_id;
    public $receiver_id;
    public $receiver_name;
    public $receiver_organization;
    public $receiver_address;
    public $content;
    public $is_external = false;
    public $users;

    public function mount($templateId)
    {
        $this->templateId = $templateId;
        $this->template = LetterTemplate::findOrFail($templateId);
        $this->users = User::all();
        $this->sender_id = auth()->id();
    }

    protected $rules = [
        'title' => 'required|string|max:255',
        'sender_id' => 'required|exists:users,id',
        'receiver_id' => 'nullable|exists:users,id',
        'receiver_name' => 'nullable|string|max:255',
        'receiver_organization' => 'nullable|string|max:255',
        'receiver_address' => 'nullable|string|max:255',
        'content' => 'required|string',
        'is_external' => 'boolean',
    ];

    public function saveLetter()
    {
        $this->validate();

        Letter::create([
            'title' => $this->title,
            'sender_id' => $this->sender_id,
            'receiver_id' => $this->is_external ? null : $this->receiver_id,
            'receiver_name' => $this->is_external ? $this->receiver_name : null,
            'receiver_organization' => $this->is_external ? $this->receiver_organization : null,
            'receiver_address' => $this->is_external ? $this->receiver_address : null,
            'content' => $this->content,
            'template_id' => $this->templateId,
            'is_external' => $this->is_external,
        ]);

        session()->flash('message', 'نامه با موفقیت ذخیره شد.');
        $this->resetFields();
    }

    public function resetFields()
    {
        $this->title = '';
        $this->receiver_id = null;
        $this->receiver_name = '';
        $this->receiver_organization = '';
        $this->receiver_address = '';
        $this->content = '';
        $this->is_external = false;
    }

    #[layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.letter.create.create-letter-form');
    }
}
