<?php
namespace App\Livewire\Admin\Letter\Form;

use App\Models\LetterForm;
use Livewire\Attributes\Layout;
use Livewire\Component;

class LetterFormList extends Component
{
    // فیلد جستجو که به wire:model.debounce متصل است.
    public $search = '';

    /**
     * انتخاب سربرگ و ریدایرکت به صفحه ایجاد نامه.
     * @param int $formId
     * @return \Illuminate\Http\RedirectResponse|\Illuminate\Http\Response
     */
    public function selectForm($formId)
    {
        $form = LetterForm::find($formId);

        if ($form) {
            // ریدایرکت با پاس دادن templateId به کامپوننت CreateLetter
            return redirect()->route('admin.create.letter', ['templateId' => $formId]);
        } else {
            // ارسال هشدار خطا به صورت SweetAlert/Toast در فرانت‌اند
            $this->dispatch('show-sweet-alert', [
                'icon' => 'error',
                'title' => 'خطا!',
                'text' => 'سربرگ انتخاب شده یافت نشد.'
            ]);
            // اگر از Livewire 3+ استفاده می‌کنید، نیازی به return نیست و فقط dispatch کافی است
            return;
        }
    }

    /**
     * رندر کردن View و اجرای منطق جستجو.
     * @return \Illuminate\Contracts\View\View
     */
    #[Layout('admin.master')]
    public function render()
    {
        // کوئری برای واکشی فرم‌ها با اعمال فیلتر جستجو
        $letterForms = LetterForm::when($this->search, function($query) {
            $query->where('name', 'like', '%' . $this->search . '%');
        })->orderByDesc('id')->get();

        return view('livewire.admin.letter.form.letter-form-list', [
            'letterForms' => $letterForms
        ]);
    }
}
