<?php

namespace App\Livewire\Admin\Letter\Form;

use Livewire\Component;

use App\Models\Letter;
use App\Models\User;
use App\Models\LetterAproval;
use App\Models\Template;
use Auth;

class LetterFormManagement extends Component
{

    public $letters;
    public $subject;
    public $body;
    public $selectedUsers = [];
    public $users;
    public $templates;
    public $selectedTemplate;

    public function mount()
    {
        $this->letters = Letter::with('user', 'approvals.user')->get();
        $this->users = User::all();
        $this->templates = Template::all();
    }

    protected $rules = [
        'subject' => 'required|string|max:255',
        'body' => 'required|string',
        'selectedUsers' => 'required|array|min:1',
        'selectedUsers.*' => 'exists:users,id',
        'selectedTemplate' => 'nullable|exists:templates,id',
    ];

    public function updatedSelectedTemplate($value)
    {
        if ($value) {
            $template = Template::find($value);
            $this->body = $template->content;
        } else {
            $this->body = '';
        }
    }

    public function saveLetter()
    {
        $this->validate();

        $letter = Letter::create([
            'user_id' => Auth::id(),
            'subject' => $this->subject,
            'body' => $this->body,
        ]);

        foreach ($this->selectedUsers as $userId) {
            LetterAproval::create([
                'letter_id' => $letter->id,
                'user_id' => $userId,
                'is_approved' => false,
            ]);
        }

        session()->flash('message', 'نامه با موفقیت ثبت شد.');
        $this->resetFields();
        $this->letters = Letter::with('user', 'approvals.user')->get();
    }

    public function resetFields()
    {
        $this->subject = '';
        $this->body = '';
        $this->selectedUsers = [];
        $this->selectedTemplate = null;
    }


    public function render()
    {
        return view('livewire.admin.letter.form.letter-form-management' , [
            'letters' => $this->letters,
            'users' => $this->users,
            'templates' => $this->templates,
        ]);
    }
}
