<?php

namespace App\Livewire\Admin\Letter;
use Livewire\Attributes\Layout;
use Livewire\Component;
use App\Models\Letter;


class LetterReminder extends Component
{
    public $letter_id;
    public $reminder_date;
    public $reminders;

    public function mount()
    {
        $this->reminders = \App\Models\LetterReminder::all();  // فراخوانی داده‌ها بدون استفاده از `with`
    }

    protected $rules = [
        'letter_id' => 'required|exists:letters,id',
        'reminder_date' => 'required|date|after:today',
    ];

    public function saveReminder()
    {
        $this->validate();

        \App\Models\LetterReminder::create([
            'letter_id' => $this->letter_id,
            'reminder_date' => $this->reminder_date,
        ]);

        session()->flash('message', 'یادآوری با موفقیت ذخیره شد.');
        $this->resetFields();
        $this->reminders = \App\Models\LetterReminder::all();  // به‌روزرسانی داده‌ها
    }

    public function resetFields()
    {
        $this->letter_id = null;
        $this->reminder_date = null;
    }


    #[layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.letter.letter-reminder', [ 'letters' => Letter::all(), 'reminders' => $this->reminders, ]);
    }
}
