<?php

namespace App\Livewire\Admin\Letter;

use App\Models\Letter;
use Livewire\Attributes\Layout;
use Livewire\Component;

class LetterSearch extends Component
{
    public $query;
    public $letters;

    public function mount()
    {
        $this->letters = collect();
    }

    public function search()
    {
        $this->letters = Letter::where('title', 'like', '%'.$this->query.'%')
            ->orWhere('content', 'like', '%'.$this->query.'%')
            ->orWhereHas('sender', function($query) {
                $query->where('name', 'like', '%'.$this->query.'%');
            })
            ->orWhereHas('receiver', function($query) {
                $query->where('name', 'like', '%'.$this->query.'%');
            })
            ->get();
    }

    #[layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.letter.letter-search', [
            'letters' => $this->letters,
        ]);
    }
}
