<?php

namespace App\Livewire\Admin\Letter;

use App\Models\Letter;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;

#[Layout('admin.master')]
class Letters extends Component
{
    use WithPagination;

    protected $paginationTheme = 'bootstrap';

    // فیلترها
    public string $search = '';
    public string $searchCode = '';
    public string $status = 'all';
    public bool $SortId = false;

    // انتخاب‌ها
    public array $selectedLetterIds = [];
    public bool $selectAll = false;

    // مدیریت مودال‌ها
    public bool $showPreviewModal = false;
    public ?Letter $previewLetter = null;

    // تغییر فیلترها => ریست صفحه
    public function updatingSearch() { $this->resetPage(); }
    public function updatingSearchCode() { $this->resetPage(); }
    public function updatingStatus() { $this->resetPage(); }
    public function updatingSortId() { $this->resetPage(); }

    // انتخاب همه
    public function updatedSelectAll($value): void
    {
        if ($value) {
            $this->selectedLetterIds = $this->letters()->pluck('id')->toArray();
        } else {
            $this->selectedLetterIds = [];
        }
    }

    // تغییر مرتب‌سازی
    public function toggleSortId(): void
    {
        $this->SortId = !$this->SortId;
        $this->resetPage();
    }

    // عملیات‌ها
    public function signLetter(int $letterId): void
    {
        $letter = Letter::findOrFail($letterId);
        if ($letter->status !== 'pending_sign') return;

        $letter->update([
            'status' => 'signed',
            'signed_at' => now()
        ]);

        $this->dispatch('show-toast', type: 'success', message: '✅ نامه با موفقیت امضا شد.');
    }

    public function bulkDelete(): void
    {
        if (empty($this->selectedLetterIds)) return;

        Letter::whereIn('id', $this->selectedLetterIds)->delete();
        $this->selectedLetterIds = [];
        $this->selectAll = false;
        $this->dispatch('show-toast', type: 'success', message: '✅ نامه‌های انتخابی با موفقیت حذف شدند.');
    }

    // نمایش پیش‌نمایش
    public function showPreview(int $letterId): void
    {
        $this->previewLetter = Letter::with([
            'sender',
            'classification',
            'referrals',
            'receivers'
        ])->findOrFail($letterId);
        $this->showPreviewModal = true;
    }

    public function closePreview(): void
    {
        $this->showPreviewModal = false;
        $this->previewLetter = null;
    }

    // کوئری اصلی
    public function letters()
    {
        return Letter::with(['sender', 'classification', 'referrals', 'receivers'])
            ->when($this->search, fn($q) => $q->where('title', 'like', "%{$this->search}%"))
            ->when($this->searchCode, fn($q) => $q->where('code', 'like', "%{$this->searchCode}%"))
            ->when($this->status !== 'all', fn($q) => $q->where('status', $this->status))
            ->orderBy('id', $this->SortId ? 'ASC' : 'DESC')
            ->paginate(12);
    }

    public function render()
    {
        return view('livewire.admin.letter.letters', [
            'letters' => $this->letters(),
            'selectedLetterIds' => $this->selectedLetterIds,
        ]);
    }
}
