<?php

namespace App\Livewire\Admin\Letter;

use App\Models\Letter;
use App\Models\Referral;
use App\Models\User;
use Livewire\Attributes\Layout;
use Livewire\Component;

class ReferralManagement extends Component
{
    public $letter_id, $user_id, $type, $comment;
    public $letters, $users;

    public function mount()
    {
        $this->letters = Letter::all();
        $this->users = User::all();
    }

    protected $rules = [
        'letter_id' => 'required|exists:letters,id',
        'user_id' => 'required|exists:users,id',
        'type' => 'required|string',
        'comment' => 'nullable|string',
    ];

    public function saveReferral()
    {
        $this->validate();

        Referral::create([
            'letter_id' => $this->letter_id,
            'user_id' => $this->user_id,
            'type' => $this->type,
            'comment' => $this->comment,
        ]);

        session()->flash('message', 'ارجاع با موفقیت ذخیره شد.');
        $this->resetFields();
    }

    public function resetFields()
    {
        $this->letter_id = null;
        $this->user_id = null;
        $this->type = null;
        $this->comment = null;
    }

    #[layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.letter.referral-management');
    }
}
