<?php

namespace App\Livewire\Admin\Letter;

use App\Models\Letter;
use App\Models\User;
use App\Models\Referral;
use Livewire\Component;
use Livewire\Attributes\Rule;

class ReferralModal extends Component
{
    public Letter $letter;
    public $users;

    // فیلدهای مودال
    #[Rule('required|exists:users,id')]
    public $recipientId;

    #[Rule('required|string|in:action,info,follow-up')]
    public $type = 'action';

    #[Rule('nullable|string|max:500')]
    public $comment;

    public function mount(int $letterId): void
    {
        $this->letter = Letter::findOrFail($letterId);
        // لیست کاربران فعال برای ارجاع
        $this->users = User::where('is_active', true)->get(['id', 'name']);
    }

    public function submitReferral(): void
    {
        $this->validate();

        // 1. ثبت ارجاع (مدل Referral باید وجود داشته باشد)
        Referral::create([
            'letter_id' => $this->letter->id,
            'user_id' => $this->recipientId,
            'type' => $this->type,
            'comment' => $this->comment,
            'created_by' => auth()->id(),
            'status' => 'pending',
        ]);

        // 2. اعلان به کامپوننت والد (ProjectLettersIndex) برای بستن مودال
        $this->dispatch('referral-created');

        session()->flash('success', 'ارجاع نامه با موفقیت ثبت شد.');
        $this->reset(['recipientId', 'comment']);
    }

    public function render()
    {
        return view('livewire.admin.letter.referral-modal');
    }
}
