<?php

namespace App\Livewire\Admin\Letter;

use App\Models\Letter;
use App\Models\LetterView;
use Livewire\Component;

class ShowLetters extends Component
{

    public $letter;
    public $letterId;

    public function mount($letterId)
    {
        $this->letterId = $letterId;
        $this->letter = Letter::with('attachments', 'referrals', 'views.user')->findOrFail($letterId);

        // ثبت مشاهده نامه
        LetterView::create([
            'letter_id' => $this->letterId,
            'user_id' => auth()->id(),
        ]);
    }


    public function render()
    {
        return view('livewire.admin.letter.show-letters', ['letter' => $this->letter] );
    }
}
