<?php

namespace App\Livewire\Admin\Letter\Template;

use App\Models\LetterTemplate;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithFileUploads;

class LetterTemplateManager extends Component
{
    use WithFileUploads;

    public $templates;
    public $name, $header, $footer, $logo, $address, $fax, $phone, $has_attachment_indicator;

    public function mount()
    {
        $this->templates = LetterTemplate::all();
    }

    protected $rules = [
        'name' => 'required|string|max:255',
        'header' => 'required|string',
        'footer' => 'required|string',
        'logo' => 'nullable|image|max:1024',
        'address' => 'nullable|string',
        'fax' => 'nullable|string',
        'phone' => 'nullable|string',
        'has_attachment_indicator' => 'boolean',
    ];

    public function saveTemplate()
    {
        $this->validate();

        $logoPath = $this->logo ? $this->logo->store('logos', 'public') : null;

        LetterTemplate::create([
            'name' => $this->name,
            'header' => $this->header,
            'footer' => $this->footer,
            'logo_path' => $logoPath,
            'address' => $this->address,
            'fax' => $this->fax,
            'phone' => $this->phone,
            'has_attachment_indicator' => $this->has_attachment_indicator,
        ]);

        session()->flash('message', 'قالب با موفقیت ذخیره شد.');
        $this->resetFields();
    }

    public function resetFields()
    {
        $this->name = '';
        $this->header = '';
        $this->footer = '';
        $this->logo = null;
        $this->address = '';
        $this->fax = '';
        $this->phone = '';
        $this->has_attachment_indicator = false;
    }

    #[layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.letter.template.letter-template-manager');
    }
}
