<?php

namespace App\Livewire\Admin\MDR;

use Livewire\Component;
use Livewire\Attributes\Url; // ⬅️ این را اضافه کنید
use App\Models\Project;
use App\Models\DocumentRevision;

class ProjectPoiSettings extends Component
{
    #[Url] // ⬅️ این attribute باعث می‌شود projectId از query string یا route بخواند
    public $projectId;

    public $weights = [];

    public function mount()
    {
        if (!$this->projectId) {
            abort(404, 'پروژه مشخص نشده است.');
        }

        $project = Project::with('poiWeights')->findOrFail($this->projectId);
        $this->weights = $project->poiWeights->pluck('weight_percent', 'poi_type')->toArray();

        foreach (DocumentRevision::POI_TYPES as $key => $label) {
            $this->weights[$key] = $this->weights[$key] ?? 0;
        }
    }

    public function save()
    {
        $project = Project::findOrFail($this->projectId);

        foreach ($this->weights as $poi => $percent) {
            // اعتبارسنجی: عدد بین 0 تا 100
            $percent = max(0, min(100, (float) $percent));
            $project->poiWeights()->updateOrCreate(
                ['poi_type' => $poi],
                ['weight_percent' => $percent]
            );
        }

        $this->dispatch('saved');
        session()->flash('success', '✅ درصد‌های POI با موفقیت ذخیره شدند.');
    }

    public function render()
    {
        return view('livewire.admin.m-d-r.project-poi-settings')
            ->layout('admin.master');
    }
}
