<?php

namespace App\Livewire\Admin\MDR;

use Livewire\Component;
use App\Models\MasterDocument;

class ShowMdr extends Component
{
    public $doc;

    public function mount($id)
    {
        $this->doc = MasterDocument::with(['project', 'discipline', 'revisions', 'documentFiles', 'transmittals.transmittal'])->findOrFail($id);
    }

    public function render()
    {
        return view('livewire.admin.m-d-r.show-mdr', [
            'doc' => $this->doc
        ])->layout('admin.master');
    }
}
