<?php

namespace App\Livewire\Admin\PettyCash;

use App\Models\PettyCash;
use Livewire\Component;

class ShowRequest extends Component
{
    public PettyCash $pettyCash;

    // 🎯 متغیر جدید برای ذخیره URL چاپ (PDF)
    public $pdfUrl;

    public function mount($id)
    {
        // 🎯 بارگذاری کامل تمام روابط برای نمایش جزئیات جامع
        $this->pettyCash = PettyCash::with([
            'user',
            'projects',
            'approvals.approver'
        ])->findOrFail($id);

        // تولید URL PDF برای دکمه چاپ
        $this->pdfUrl = route('admin.petty-cash.pdf', $id);
    }

    // 🎯 متد کمکی برای دریافت تعداد تأییدهای مورد نیاز
    public function getRequiredCount(): int
    {
        // فرض می‌کنیم متد getRequiredApprovalsCount() در مدل PettyCash موجود است
        return $this->pettyCash->getRequiredApprovalsCount();
    }

    // 🎯 متد برای چاپ (فراخوانی از Modal)
    public function printPdf()
    {
        // نیازی به منطق پیچیده در اینجا نیست، فقط هدایت به URL تعریف شده در mount
        $this->dispatch('printDocument', url: $this->pdfUrl);
    }

    public function render()
    {
        // از آنجایی که داده‌ها در mount بارگذاری شده‌اند، مستقیماً به ویو ارسال می‌شوند
        return view('livewire.admin.petty-cash.show-request')
            ->layout('admin.master');
    }
}
