<?php

namespace App\Livewire\Admin\Project;

use App\Models\User;
use App\Models\Project;
use App\Models\Role;
use Livewire\Component;
use Illuminate\Foundation\Auth\Access\AuthorizesRequests; // 💡 اضافه شدن تریت authorize
use Livewire\Attributes\Layout;

#[Layout('admin.master')]
class ProjectRoleAssignment extends Component
{
    // 💡 اضافه شدن تریت authorize
    use AuthorizesRequests;

    // لیست تمام کاربران، پروژه‌ها و نقش‌های مجاز پروژه‌ای
    public $users;
    public $projects;
    public $projectRoles;

    // متغیرهای فرم
    public $selectedUser;
    public $selectedProject;
    public $selectedRole;

    public function mount()
    {
        // 🚨 گارد امنیتی
        $this->authorize('manage_project_roles');

        // واکشی داده‌ها: استفاده از نام ستون واقعی (name) و select بهینه
        $this->users = User::select('id', 'name', 'email')->orderBy('name')->get();
        // 🛑 FIX: استفاده از 'name' به جای 'title' در واکشی
        $this->projects = Project::select('id', 'name')->orderBy('name')->get();

        // واکشی نقش‌های پروژه‌ای
        // 🛑 FIX: استفاده از نام ستون ثابت برای فیلتر
        $this->projectRoles = Role::where('is_project_role', true)->select('id', 'label', 'name')->get();
    }

    // متد اصلی برای تخصیص نقش (بدون تغییر در منطق اصلی)
    public function assignProjectRole()
    {
        $this->validate([
            'selectedUser' => 'required|exists:users,id',
            'selectedProject' => 'required|exists:projects,id',
            'selectedRole' => 'required|exists:roles,id',
        ]);

        $user = User::find($this->selectedUser);

        try {
            $user->projects()->syncWithoutDetaching([
                $this->selectedProject => [
                    'role_id' => $this->selectedRole,
                    'status' => 'active'
                ]
            ]);

            session()->flash('success', 'نقش پروژه با موفقیت اختصاص یافت.');
            $this->reset(['selectedUser', 'selectedProject', 'selectedRole']);
        } catch (\Exception $e) {
            session()->flash('error', 'خطا در ثبت نقش پروژه.');
        }
    }

    public function render()
    {
        // 💡 حذف متد layout از اینجا و استفاده از attribute
        return view('livewire.admin.project.project-role-assignment');
    }
}
