<?php

namespace App\Livewire\Admin\ProjectFiles;

use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\Storage;

class ProjectFileUpload extends Component
{
    use WithFileUploads;

    public $files = [];
    public $uploadedFiles = [];

    protected $rules = [
        'files.*' => 'required|file|max:20480|mimes:jpg,jpeg,png,pdf,docx,zip,doc',
    ];

    public function updatedFiles()
    {
        $this->validate();
        $this->uploadedFiles = $this->files;
    }

    public function removeFile($index)
    {
        unset($this->uploadedFiles[$index]);
        $this->uploadedFiles = array_values($this->uploadedFiles);
        $this->files = $this->uploadedFiles;
    }

    public function upload()
    {
        $this->validate();

        foreach ($this->files as $file) {
            $fileName = time() . '_' . $file->getClientOriginalName();
            $file->storeAs('Project/File', $fileName, 'public');
        }

        $this->reset();
        session()->flash('message', 'فایل‌ها با موفقیت آپلود شدند.');
    }
    #[layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.project-files.project-file-upload');
    }
}
