<?php
namespace App\Livewire\Admin\Projects;

use App\Models\Project;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Illuminate\Support\Str;

class ProjectCreateOrRename extends Component
{
    public $projectId;
    public $name;
    public $code;

    public function mount($projectId = null)
    {
        if ($projectId && $projectId != 0) {
            $project = Project::findOrFail($projectId);
            $this->projectId = $project->id;
            $this->name = $project->name;
            $this->code = $project->code;
        }
    }

    protected function rules()
    {
        return [
            'name' => 'required|min:3|max:255',
            'code' => 'required|alpha_dash|unique:projects,code,' . $this->projectId,
        ];
    }

    public function save()
    {
        $this->validate();

        $data = [
            'name' => $this->name,
            'code' => strtoupper($this->code),
        ];

        if ($this->projectId) {
            Project::find($this->projectId)->update($data);
            $message = 'پروژه با موفقیت به‌روزرسانی شد.';
        } else {
            Project::create($data);
            $message = 'پروژه جدید با موفقیت تعریف شد.';
        }

        session()->flash('success', $message);
        return redirect()->route('admin.projects'); // نام روت خود را چک کنید
    }

    #[Layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.projects.project-create-or-rename');
    }
}
