<?php

namespace App\Livewire\Admin\Projects;

use App\Models\Company;
use App\Models\ProjectRole;
use Livewire\Attributes\Layout;
use Livewire\Component;

class ProjectRoleManager extends Component
{
    public $project_id; // پارامتر برای دریافت projectId از URL
    public $roles = [];  // لیست نقش‌ها
    public $roleTypes = ['پیمانکار', 'مشاور', 'مدیر پروژه', 'سایر']; // انواع نقش‌ها
    public $companies; // شرکت‌ها

    // mount method for initial setup
    public function mount($projectId) // گرفتن projectId از URL
    {
        $this->project_id = $projectId; // ذخیره projectId
        $this->companies = Company::all(); // بارگذاری لیست شرکت‌ها

        // بارگذاری نقش‌های موجود برای پروژه
        $projectRoles = ProjectRole::where('project_id', $projectId)->get();
        foreach ($projectRoles as $role) {
            $this->roles[] = [
                'role_type' => $role->role_type,
                'company_id' => $role->company_id,
            ];
        }
    }
    #[layout('admin.master')]
    // Rendering the view
    public function render()
    {
        return view('livewire.admin.projects.project-role-manager');
    }

    // افزودن نقش جدید به لیست
    public function addRole()
    {
        $this->roles[] = ['role_type' => '', 'company_id' => ''];
    }

    // حذف نقش از لیست
    public function removeRole($index)
    {
        unset($this->roles[$index]);
        $this->roles = array_values($this->roles); // Re-index array
    }

    // ذخیره نقش‌ها
    public function saveRoles()
    {
        $this->validate([
            'roles.*.role_type' => 'required',
            'roles.*.company_id' => 'required|exists:companies,id',
        ]);

        // ذخیره نقش‌ها در دیتابیس
        foreach ($this->roles as $role) {
            ProjectRole::updateOrCreate(
                ['project_id' => $this->project_id, 'role_type' => $role['role_type']],
                ['company_id' => $role['company_id']]
            );
        }

        session()->flash('message', 'نقش‌ها با موفقیت ذخیره شدند.');
    }
}
