<?php

namespace App\Livewire\Admin\Projects;

use App\Models\Project;
use Livewire\Attributes\Layout;
use Livewire\Component;

class ProjectViewComponent extends Component
{
    public $projectId;
    public $project;

    // بارگذاری اطلاعات پروژه با شناسه پروژه
    public function mount($projectId)
    {
        $this->projectId = $projectId;
       // $this->project = Project::with('details', 'company', 'projectTypes')->find($projectId);
        $this->project = Project::with('details', 'projectTypes','schedule','insurances')->find($projectId);
        // در صورتی که پروژه پیدا نشد، به صفحه لیست هدایت می‌کنیم
        if (!$this->project) {
            return redirect()->route('admin.list.projects');
        }
    }

    #[layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.projects.project-view-component');
    }
}
