<?php

namespace App\Livewire\Admin\Projects;

use Livewire\Component;
use App\Models\ProjectWallPost;
use App\Models\WallPostComment;

class ProjectWallCommentsModal extends Component
{
    public $postId;

    public function mount($postId)
    {
        $this->postId = $postId;
    }

    public function getCommentsProperty()
    {
        return WallPostComment::where('project_wall_post_id', $this->postId)
            ->with('user:id,name,image')
            ->latest()
            ->get();
    }

    public function render()
    {
        return view('livewire.admin.projects.project-wall-comments-modal', [
            'comments' => $this->comments,
            'post' => ProjectWallPost::find($this->postId),
        ]);
    }
}
