<?php

namespace App\Livewire\Admin\Projects;

use App\Models\Project;
use App\Models\ProjectDetail;
use App\Models\ProjectFinancialDetail;
use App\Models\ProjectSchedule;
use App\Models\Section;
use Livewire\Attributes\Layout;
use Livewire\Attributes\On;
use Livewire\Component;

class ShowSections extends Component
{
    public $project;
    public $projectId;
    public $contract_value, $currency_unit, $exchange_rate;
    public $LOA_date, $contract_date, $actual_completion_date, $execution_duration;

    public $project_code, $tax_code, $main_client_id, $sub_client_id, $contractor_id, $manager_id, $status, $project_types = [];


    public function mount($projectId)
    {
        $this->projectId = $projectId;
        $this->project = Project::with('sections.files')->find($projectId);



        if ($finance = ProjectFinancialDetail::where('project_id', $projectId)->first())
        {
            $this->contract_value = $finance->contract_value;
            $this->currency_unit = $finance->currency_unit;
            $this->exchange_rate= $finance->exchange_rate;

        }
        else {
            $this->contract_value = '';
            $this->currency_unit = '';
            $this->exchange_rate = '';
        }

        if ($schedule = ProjectSchedule::where('project_id', $projectId)->first())
        {
            $this->LOA_date = $schedule->LOA_date;
            $this->contract_date = $schedule->contract_date;
            $this->actual_completion_date= $schedule->actual_completion_date;
            $this->execution_duration= $schedule->execution_duration;

        }
        else {
            $this->LOA_date = '';
            $this->contract_date = '';
            $this->actual_completion_date = '';
            $this->execution_duration = '';
        }

        if ($projectDetail = ProjectDetail::where('project_id', $projectId)->first())
        {
            $this->project_code = $projectDetail->project_code;
            $this->tax_code = $projectDetail->tax_code;
            $this->main_client_id = $projectDetail->main_client_id;
            $this->sub_client_id= $projectDetail->sub_client_id;
            $this->contractor_id = $projectDetail->contractor_id;
            $this->manager_id = $projectDetail->manager_id;
            $this->status = $projectDetail->status;
            $this->project_types = $projectDetail->project->projectTypes->pluck('id')->toArray(); }
        else {
            $this->project_code = '';
            $this->tax_code = '';
            $this->main_client_id = '';
            $this->sub_client_id = '';
            $this->contractor_id = '';
            $this->manager_id = '';
            $this->status = '';
            $this->project_types = []; }
    }



    #[On('SectionCreated')]
    public function SectionCreated()
    {

    }
    #[layout('admin.master')]
    public function render()
    {

        return view('livewire.admin.projects.show-sections',[ 'project' => $this->project,
            'contract_value' => $this->contract_value,
            'currency_unit' => $this->currency_unit,
            'exchange_rate' => $this->exchange_rate])
            ;
    }
}
