<?php

namespace App\Livewire\Admin\Projects\Type;

use App\Models\ProjectType;
use Illuminate\Support\Str;
use Livewire\Attributes\{Layout, Rule, Computed};
use Livewire\Component;

class ProjectTypeCreate extends Component
{
    #[Rule('required|min:2|unique:project_types,name', as: 'نام نوع پروژه')]
    public $name = '';

    // دریافت لیست انواع پروژه‌ها به صورت بهینه
    #[Computed]
    public function projectTypes()
    {
        return ProjectType::latest()->get();
    }

    public function saveType()
    {
        $this->validate();

        try {
            ProjectType::create([
                'name' => $this->name,
                'slug' => Str::slug($this->name)
            ]);

            $this->reset('name');
            $this->dispatch('alert', ['type' => 'success', 'message' => 'دسته‌بندی با موفقیت ایجاد شد.']);

        } catch (\Exception $e) {
            $this->dispatch('alert', ['type' => 'error', 'message' => 'خطا در ثبت اطلاعات!']);
        }
    }

    public function deleteType($id)
    {
        ProjectType::destroy($id);
        $this->dispatch('alert', ['type' => 'warning', 'message' => 'آیتم حذف گردید.']);
    }

    #[Layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.projects.type.project-type-create');
    }
}
