<?php

namespace App\Livewire\Admin\Projects\Type;

use App\Models\ProjectType;
use Livewire\Attributes\{Layout, On, Url, Computed};
use Livewire\Component;
use Livewire\WithPagination;

class ProjectTypeList extends Component
{
    use WithPagination;

    #[Url(history: true, keep: true)]
    public $search = "";

    public $sortField = 'id';
    public $sortDirection = 'desc';

    protected $paginationTheme = 'bootstrap';

    // ریست کردن پگینیشن هنگام جستجو
    public function updatedSearch()
    {
        $this->resetPage();
    }

    #[On('ProjectType-Created')]
    public function refreshList()
    {
        $this->resetPage();
    }

    public function sortBy($field)
    {
        if ($this->sortField === $field) {
            $this->sortDirection = $this->sortDirection === 'asc' ? 'desc' : 'asc';
        } else {
            $this->sortDirection = 'asc';
        }
        $this->sortField = $field;
    }

    public function deleteType($id)
    {
        try {
            $type = ProjectType::findOrFail($id);
            // چک کردن اینکه آیا پروژه‌ای به این تایپ متصل است یا خیر (امنیت داده)
            if ($type->projects()->exists()) {
                $this->dispatch('alert', ['type' => 'error', 'message' => 'این دسته دارای پروژه فعال است و قابل حذف نیست!']);
                return;
            }

            $type->delete();
            $this->dispatch('alert', ['type' => 'success', 'message' => 'دسته‌بندی با موفقیت از سیستم حذف شد.']);
        } catch (\Exception $e) {
            $this->dispatch('alert', ['type' => 'error', 'message' => 'خطای سیستمی در حذف داده!']);
        }
    }

    #[Layout('admin.master')]
    public function render()
    {
        $projectTypes = ProjectType::query()
            ->where('name', 'LIKE', '%' . $this->search . '%')
            ->orderBy($this->sortField, $this->sortDirection)
            ->paginate(8);

        return view('livewire.admin.projects.type.project-type-list', compact('projectTypes'));
    }
}
