<?php

namespace App\Livewire\Admin\Purchase;

use App\Models\PurchaseRequest;
use App\Models\PurchaseRequestApproval;
use Illuminate\Support\Facades\Auth;
use Livewire\Attributes\Layout;
use Livewire\Component;

class ApprovalAction extends Component
{
    public $requestId;
    public $comment;

    public function mount($requestId)
    {
        $this->requestId = $requestId;
    }

    public function approve()
    {
        $request = PurchaseRequest::findOrFail($this->requestId);
        $approval = $request->approvals()->where('user_id', Auth::id())->first();
        if ($approval) {
            $approval->update([
                'is_approved' => true,
                'approved_at' => now(),
                'comment' => $this->comment,
            ]);
            // بررسی وضعیت کلی درخواست (مثلاً در کامپوننت اصلی)
            $this->dispatch('approval-updated');
            session()->flash('message', 'درخواست با موفقیت تأیید شد.');
            $this->reset(['comment']);
        }
    }

    public function reject()
    {
        $request = PurchaseRequest::findOrFail($this->requestId);
        $approval = $request->approvals()->where('user_id', Auth::id())->first();
        if ($approval) {
            $approval->update([
                'is_approved' => false,
                'approved_at' => now(),
                'comment' => $this->comment,
            ]);
            // بررسی وضعیت کلی درخواست (مثلاً در کامپوننت اصلی)
            $this->dispatch('approval-updated');
            session()->flash('message', 'درخواست با موفقیت رد شد.');
            $this->reset(['comment']);
        }
    }

    public function return()
    {
        $request = PurchaseRequest::findOrFail($this->requestId);
        $approval = $request->approvals()->where('user_id', Auth::id())->first();
        if ($approval) {
            $approval->update([
                'is_approved' => null,
                'comment' => $this->comment,
            ]);
            $request->update(['status' => 'returned']);
            $this->dispatch('approval-updated');
            session()->flash('message', 'درخواست برای اصلاح برگشت داده شد.');
            $this->reset(['comment']);
        }
    }
    #[layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.purchase.approval-action');
    }
}
