<?php

namespace App\Livewire\Admin\Roles;

use App\Models\Role;
use Livewire\Attributes\Layout;
use Livewire\Attributes\On;
use Livewire\Component;

class RolesList extends Component
{
    // گوش دادن به رویدادهای AddRoles برای به‌روزرسانی خودکار لیست
    #[On('role-created'), On('role-updated'), On('role-deleted')]
    public function updateRolesList()
    {
        // Livewire به طور خودکار این کامپوننت را دوباره رندر می‌کند.
    }

    // انتشار رویداد برای درخواست ویرایش (شنیده شده توسط AddRoles)
    public function dispatchEditRole(int $roleId): void
    {
        $this->dispatch('edit-role-request', roleId: $roleId);
    }

    // انتشار رویداد برای درخواست حذف (شنیده شده توسط AddRoles)
    public function dispatchDeleteRole(int $roleId): void
    {
        $this->dispatch('delete-role-request', roleId: $roleId);
    }

    public function render()
    {
        // *مشکل آدرس ویو رفع شد*
        $roles = Role::select('id', 'name')->orderBy('name')->get();
        return view('livewire.admin.roles.roles-list', compact('roles'))->layout('admin.master');
    }
}
