<?php

namespace App\Livewire\Admin\Sales;

use App\Models\SalesInvoice;
use App\Models\Project;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithPagination;
use Livewire\Attributes\Computed;
use Illuminate\Support\Facades\DB;
use Morilog\Jalali\Jalalian;

#[Layout('admin.master')]
class SalesInvoiceList extends Component
{
    use WithPagination;

    public string $search = '';
    public string $statusFilter = '';
    public string $projectFilter = '';
    protected string $paginationTheme = 'bootstrap';

    public function updatingSearch() { $this->resetPage(); }
    public function updatingStatusFilter() { $this->resetPage(); }
    public function updatingProjectFilter() { $this->resetPage(); }

    public function getSalesInvoicesProperty()
    {
        return SalesInvoice::with(['project'])
            ->when($this->search, fn ($q) =>
            $q->where('client_name', 'like', "%{$this->search}%")
                ->orWhere('invoice_number', 'like', "%{$this->search}%")
                ->orWhere('description', 'like', "%{$this->search}%")
            )
            ->when($this->statusFilter, fn ($q) => $q->where('status', $this->statusFilter))
            ->when($this->projectFilter, fn ($q) => $q->where('project_id', $this->projectFilter))
            ->orderByDesc('issue_date')
            ->paginate(10);
    }

    public function getProjectsProperty()
    {
        return Project::select('id', 'name')->get();
    }

    // 💡 متد ساختار داده وضعیت‌ها
    public function getStatusData(string $status): array
    {
        return match ($status) {
            'issued' => ['label' => 'صادر شده', 'color' => 'info', 'icon' => 'ti-file-text'],
            'paid' => ['label' => 'پرداخت شده', 'color' => 'success', 'icon' => 'ti-cash'],
            'canceled' => ['label' => 'لغو شده', 'color' => 'danger', 'icon' => 'ti-x'],
            default => ['label' => 'نامشخص', 'color' => 'secondary', 'icon' => 'ti-question'],
        };
    }

    public function render()
    {
        return view('livewire.admin.sales.sales-invoice-list', [
            'invoices' => $this->salesInvoices,
            'projects' => $this->projects,
        ]);
    }
}
