<?php

namespace App\Livewire\Admin\Sales;

use App\Models\SalesInvoice;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Morilog\Jalali\Jalalian;

#[Layout('admin.master')]
class ShowSalesInvoice extends Component
{
    public SalesInvoice $invoice;

    public function mount(SalesInvoice $invoice)
    {
        // 💡 لود کردن تمام روابط مورد نیاز برای نمایش
        $this->invoice = $invoice->load([
            'project:id,name',
            'user:id,name', // لود ثبت‌کننده
            'items', // جزئیات آیتم‌ها
            'attachments', // پیوست‌های فاکتور
        ]);
    }

    public function getStatusData(string $status): array
    {
        return match ($status) {
            'issued' => ['label' => 'صادر شده', 'color' => 'info', 'icon' => 'ti-file-text'],
            'paid' => ['label' => 'پرداخت شده', 'color' => 'success', 'icon' => 'ti-cash'],
            'canceled' => ['label' => 'لغو شده', 'color' => 'danger', 'icon' => 'ti-x'],
            default => ['label' => 'نامشخص', 'color' => 'secondary', 'icon' => 'ti-question'],
        };
    }

    public function getCreatedAtShamsiProperty()
    {
        return $this->invoice->created_at ? \Morilog\Jalali\Jalalian::fromCarbon($this->invoice->created_at)->format('Y/m/d H:i') : '—';
    }

    public function getDueDateShamsiProperty()
    {
        return $this->invoice->due_date ? \Morilog\Jalali\Jalalian::fromCarbon($this->invoice->due_date)->format('Y/m/d') : '—';
    }

    // --- Quick Actions ---

    public function printInvoice()
    {
        // 💡 Dispatch رویداد JS برای چاپ
        $this->dispatch('print-document');
    }

    public function recordPayment(): void
    {
        $this->invoice->update(['status' => 'paid']);
        session()->flash('message', 'وضعیت فاکتور با موفقیت به پرداخت شده تغییر یافت.');
    }

    public function cancelInvoice(): void
    {
        $this->invoice->update(['status' => 'canceled']);
        session()->flash('message', 'فاکتور با موفقیت لغو شد.');
    }

    public function render()
    {
        return view('livewire.admin.sales.show-sales-invoice', [
            'request' => $this->invoice,
        ]);
    }
}
