<?php

namespace App\Livewire\Admin\Section;

use App\Models\Project;
use App\Models\Section;
use App\Models\User;
use Livewire\Attributes\Layout;
use Livewire\Component;

class CreateSection extends Component
{
    public $users;
    public $projects;
    public $name;
    public $description;
    public $selectedProject;

    protected $rules = [
        'name' => 'required|min:2',
        'description' => 'nullable|min:2',
        'selectedProject' => 'required|exists:projects,id',
    ];

    protected $messages = [
        'name.required' => 'لطفاً نام بخش را وارد کنید.',
        'name.min' => 'نام بخش باید حداقل ۲ کاراکتر باشد.',
        'description.min' => 'توضیحات باید حداقل ۲ کاراکتر باشد.',
        'selectedProject.required' => 'لطفاً پروژه‌ای را انتخاب کنید.',
        'selectedProject.exists' => 'پروژه انتخاب شده معتبر نیست.',
    ];
    #[layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.section.create-section');
    }

    public function mount()
    {
        $this->users = User::all();
        $this->projects = Project::all();
    }

    public function CreateSection()
    {
        $this->validate();

        // ذخیره اطلاعات بخش
        Section::create([
            'name' => $this->name,
            'description' => $this->description,
            'project_id' => $this->selectedProject,
        ]);

        // ریست کردن فرم
        $this->reset(['name', 'description', 'selectedProject']);

        // ارسال پیام موفقیت
        session()->flash('message', 'بخش با موفقیت ایجاد گردید');

        // ارسال رویداد برای تغییرات در رابط کاربری
        $this->dispatch('sectionCreated');
    }
}
