<?php

namespace App\Livewire\Admin\Section;

use App\Models\Section;
use App\Models\User;
use Livewire\Attributes\Layout;
use Livewire\Attributes\On;
use Livewire\Component;
use Livewire\WithFileUploads;
use Livewire\WithPagination;

class SectionList extends Component
{
    use WithPagination,WithFileUploads;
    protected $paginationTheme = "bootstrap";
    public $EditUserIndex=null;
    public $SortId=true;
    public $search="";

    #[On('SectionCreated')]
    public function SectionCreated()
    {

    }

    #[layout('admin.master')]
    public function render()
    {
        sleep(1);
        $Sections=Section::query()->orderBy('id',$this->SortId ? 'asc' : 'desc')
            ->where('name','LIKE','%'.$this->search.'%')
//            ->orWhere('email','LIKE','%'.$this->search.'%')
            ->paginate(10);
        return view('livewire.admin.section.section-list',compact('Sections'));
    }
}
