<?php

namespace App\Livewire\Admin\Sections;

use App\Models\Section;
use App\Models\SectionFile;
use Livewire\Attributes\Layout;
use Livewire\Component;
use Livewire\WithFileUploads;
use Illuminate\Support\Facades\Storage;

class SectionFiles extends Component
{
    use WithFileUploads;

    public Section $section;
    public array $pendingFiles = []; // فقط فایل‌های انتخاب‌شده (موقت)

    public function mount(Section $section)
    {
        $this->section = $section;
    }

    public function upload()
    {
//        $this->validate([
//            'pendingFiles.*' => 'required|file|max:20480|mimes:jpg,jpeg,png,pdf,docx,zip,doc',
//        ]);
        dd('hi');
        foreach ($this->pendingFiles as $file) {
            $path = $file->store('sections/' . $this->section->id, 'public');


            $this->section->files()->create([
                'original_name' => $file->getClientOriginalName(),
                'file_path'     => $path,
                'file_type'     => $file->getMimeType(),
                'file_size'     => $file->getSize(),
            ]);
        }


        $this->reset('pendingFiles');
        session()->flash('message', 'فایل(ها) با موفقیت آپلود شد.');
        $this->section->refresh();
    }

    public function deleteFile($fileId)
    {
        $file = SectionFile::findOrFail($fileId);
        Storage::disk('public')->delete($file->file_path);
        $file->delete();
        session()->flash('message', 'فایل با موفقیت حذف شد.');
        $this->section->refresh();
    }

    public function render()
    {
        // فقط فایل‌های ذخیره‌شده را به ویو می‌فرستیم
        return view('livewire.admin.sections.section-files', [
            'section'    => $this->section,
            'savedFiles' => $this->section->files()->latest()->get(),
        ]);
    }
}
