<?php

namespace App\Livewire\Admin\Sign;

use Livewire\Attributes\Layout;
use Livewire\Component;
use App\Models\SignSetting;
use App\Models\User;
use App\Models\Role;

class SignSettingsManagement extends Component
{
    public $signSettings;
    public $user_id;
    public $role_id;
    public $priority;

    public function mount()
    {
        $this->signSettings = SignSetting::with('user', 'role')->get();
    }

    protected $rules = [
        'user_id' => 'required|exists:users,id',
        'role_id' => 'required|exists:roles,id',
        'priority' => 'required|integer|min:1',
    ];

    public function saveSignSetting()
    {
        $this->validate();

        SignSetting::create([
            'user_id' => $this->user_id,
            'role_id' => $this->role_id,
            'priority' => $this->priority,
        ]);

        session()->flash('message', 'تنظیمات امضا با موفقیت ذخیره شد.');
        $this->resetFields();
        $this->signSettings = SignSetting::with('user', 'role')->get();
    }

    public function resetFields()
    {
        $this->user_id = null;
        $this->role_id = null;
        $this->priority = null;
    }

    #[layout('admin.master')]
    public function render()
    {
        return view('livewire.admin.sign.sign-setting-management', [
                'signSettings' => $this->signSettings,
                'users' => User::all(),
                'roles' => Role::all(),
            ]);
    }
}
