<?php

namespace App\Livewire\Admin\Task;
use Livewire\Component;
use Livewire\WithFileUploads;
use App\Models\TaskFile;

class TaskFileUpload extends Component
{


    use WithFileUploads;

    public $taskId, $file, $name;

    public function save()
    {
        $this->validate(['file' => 'required|file|max:10000']);
        $path = $this->file->store('task_files', 'public');
        TaskFile::create([
            'task_id' => $this->taskId,
            'user_id' => auth()->id(),
            'file_path' => $path,
            'name' => $this->name
        ]);
        $this->reset(['file', 'name']);
    }

    public function render()
    {
        {
            return view('livewire.admin.task.task-file-upload', [
                'files' => TaskFile::where('task_id', $this->taskId)->get()
            ]);


        }
    }
}
