<?php

namespace App\Livewire\Admin\Task;

use Livewire\Component;
use App\Models\Task;
use App\Models\Project;
use Morilog\Jalali\Jalalian;

class TaskShow extends Component
{

    public $task;
    public $projectId;

    public function mount($project, $task)
    {
        // 💡 واکشی تمام روابط مهم: assignedUser, section, parent, dependency
        $this->task = Task::with([
            'assignedUser:id,name',
            'section:id,name',
            'parent:id,title,status',
            'dependency:id,title,status'
        ])->findOrFail($task);

        $this->projectId = $project;
    }

    // 💡 متد کمکی برای تبدیل تاریخ به شمسی (جهت نمایش)
    public function getPersianDate($date)
    {
        if (!$date) return '—';
        return \Morilog\Jalali\Jalalian::fromDateTime($date)->format('Y/m/d');
    }

    // 💡 متد کمکی برای ایجاد Badge وضعیت
    public function getStatusBadge(Task $task)
    {
        $status = $task->status;
        $label = $task->status_label;

        $class = match($status) {
            'done' => 'badge-success',
            'in_progress' => 'badge-warning',
            'on_hold' => 'badge-danger',
            default => 'badge-info'
        };

        // 🛑 استفاده از bg-soft برای زیبایی و color اصلی برای متن
        return "<span class='badge bg-soft-{$class} text-{$class}'>{$label}</span>";
    }


    public function render()
    {
        return view('livewire.admin.task.task-show')->layout('admin.master');
    }
}
